/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809;

import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.mc6809.Operand;
import frc.emul.mc6809.dasm.IDasmRegs;
import frc.emul.util.Utils;
import frc.emul.vectrex.PersistentSection;

public class Regs
implements IDasmRegs,
IPersistentObject {
    public static final int FLAG_E = 128;
    public static final int FLAG_F = 64;
    public static final int FLAG_H = 32;
    public static final int FLAG_I = 16;
    public static final int FLAG_N = 8;
    public static final int FLAG_Z = 4;
    public static final int FLAG_V = 2;
    public static final int FLAG_C = 1;
    public static final int FLAGS_EFHI = 240;
    public static final int FLAGS_NZVC = 15;
    public static final int FLAGS_HNZVC = 47;
    private int rA;
    private int rB;
    private int rDP;
    private int rCC;
    private int rX;
    private int rY;
    private int rU;
    private int rS;
    private int rPC;

    public Regs clone(Regs regs) {
        if (regs == null) {
            regs = new Regs();
        }
        regs.rA = this.rA;
        regs.rB = this.rB;
        regs.rDP = this.rDP;
        regs.rCC = this.rCC;
        regs.rX = this.rX;
        regs.rY = this.rY;
        regs.rU = this.rU;
        regs.rS = this.rS;
        regs.rPC = this.rPC;
        return regs;
    }

    public boolean isDPAvailable(int n) {
        return true;
    }

    public int getDP(int n) {
        return this.rDP;
    }

    public boolean isAvailable(Operand operand, int n) {
        return true;
    }

    public int getRegS(Operand operand, int n) {
        return this.getRegS(operand);
    }

    public int getRegU(Operand operand, int n) {
        return this.getRegU(operand);
    }

    public int A() {
        return this.rA;
    }

    public int B() {
        return this.rB;
    }

    public int CC() {
        return this.rCC;
    }

    public int DP() {
        return this.rDP;
    }

    public int PC() {
        return this.rPC;
    }

    public int S() {
        return this.rS;
    }

    public int U() {
        return this.rU;
    }

    public int X() {
        return this.rX;
    }

    public int Y() {
        return this.rY;
    }

    public int D() {
        return this.rA << 8 | this.rB;
    }

    public void setA(int n) {
        this.rA = n & 0xFF;
    }

    public void setB(int n) {
        this.rB = n & 0xFF;
    }

    public void setCC(int n) {
        this.rCC = n & 0xFF;
    }

    public void setDP(int n) {
        this.rDP = n & 0xFF;
    }

    public void setPC(int n) {
        this.rPC = n & 0xFFFF;
    }

    public void setS(int n) {
        this.rS = n & 0xFFFF;
    }

    public void setU(int n) {
        this.rU = n & 0xFFFF;
    }

    public void setX(int n) {
        this.rX = n & 0xFFFF;
    }

    public void setY(int n) {
        this.rY = n & 0xFFFF;
    }

    public void setD(int n) {
        this.rA = (n & 0xFF00) >> 8;
        this.rB = n & 0xFF;
    }

    public void advancePC(int n) {
        this.rPC = this.rPC + n & 0xFFFF;
    }

    public boolean CCC() {
        return (this.rCC & 1) != 0;
    }

    public boolean CCV() {
        return (this.rCC & 2) != 0;
    }

    public boolean CCZ() {
        return (this.rCC & 4) != 0;
    }

    public boolean CCN() {
        return (this.rCC & 8) != 0;
    }

    public boolean CCI() {
        return (this.rCC & 0x10) != 0;
    }

    public boolean CCH() {
        return (this.rCC & 0x20) != 0;
    }

    public boolean CCF() {
        return (this.rCC & 0x40) != 0;
    }

    public boolean CCE() {
        return (this.rCC & 0x80) != 0;
    }

    public void setCCC(boolean bl) {
        this.rCC = bl ? (this.rCC |= 1) : (this.rCC &= 0xFFFFFFFE);
    }

    public void setCCV(boolean bl) {
        this.rCC = bl ? (this.rCC |= 2) : (this.rCC &= 0xFFFFFFFD);
    }

    public void setCCZ(boolean bl) {
        this.rCC = bl ? (this.rCC |= 4) : (this.rCC &= 0xFFFFFFFB);
    }

    public void setCCN(boolean bl) {
        this.rCC = bl ? (this.rCC |= 8) : (this.rCC &= 0xFFFFFFF7);
    }

    public void setCCI(boolean bl) {
        this.rCC = bl ? (this.rCC |= 0x10) : (this.rCC &= 0xFFFFFFEF);
    }

    public void setCCH(boolean bl) {
        this.rCC = bl ? (this.rCC |= 0x20) : (this.rCC &= 0xFFFFFFDF);
    }

    public void setCCF(boolean bl) {
        this.rCC = bl ? (this.rCC |= 0x40) : (this.rCC &= 0xFFFFFFBF);
    }

    public void setCCE(boolean bl) {
        this.rCC = bl ? (this.rCC |= 0x80) : (this.rCC &= 0xFFFFFF7F);
    }

    public void setCCC() {
        this.rCC |= 1;
    }

    public void setCCV() {
        this.rCC |= 2;
    }

    public void setCCZ() {
        this.rCC |= 4;
    }

    public void setCCN() {
        this.rCC |= 8;
    }

    public void setCCI() {
        this.rCC |= 0x10;
    }

    public void setCCH() {
        this.rCC |= 0x20;
    }

    public void setCCF() {
        this.rCC |= 0x40;
    }

    public void setCCE() {
        this.rCC |= 0x80;
    }

    public void clearCCC() {
        this.rCC &= 0xFFFFFFFE;
    }

    public void clearCCV() {
        this.rCC &= 0xFFFFFFFD;
    }

    public void clearCCZ() {
        this.rCC &= 0xFFFFFFFB;
    }

    public void clearCCN() {
        this.rCC &= 0xFFFFFFF7;
    }

    public void clearCCI() {
        this.rCC &= 0xFFFFFFEF;
    }

    public void clearCCH() {
        this.rCC &= 0xFFFFFFDF;
    }

    public void clearCCF() {
        this.rCC &= 0xFFFFFFBF;
    }

    public void clearCCE() {
        this.rCC &= 0xFFFFFF7F;
    }

    public void updateFlags(int n, int n2) {
        this.rCC = this.rCC & ~n | n2;
    }

    public void clearFlags(int n) {
        this.rCC &= ~n;
    }

    public void setFlags(int n) {
        this.rCC |= n;
    }

    public int getFlags(int n) {
        return this.rCC & n;
    }

    public int getRegU(Operand operand) {
        switch (operand) {
            case REG_A: {
                return this.rA;
            }
            case REG_B: {
                return this.rB;
            }
            case REG_CC: {
                return this.rCC;
            }
            case REG_DP: {
                return this.rDP;
            }
            case REG_D: {
                return this.rA << 8 | this.rB;
            }
            case REG_X: {
                return this.rX;
            }
            case REG_Y: {
                return this.rY;
            }
            case REG_U: {
                return this.rU;
            }
            case REG_S: {
                return this.rS;
            }
            case REG_PC: {
                return this.rPC;
            }
        }
        throw new IllegalArgumentException("Not a register : " + (Object)((Object)operand));
    }

    public int getRegS(Operand operand) {
        switch (operand) {
            case REG_A: {
                return (byte)this.rA;
            }
            case REG_B: {
                return (byte)this.rB;
            }
            case REG_CC: {
                return (byte)this.rCC;
            }
            case REG_DP: {
                return (byte)this.rDP;
            }
            case REG_D: {
                return Utils.extendWord(this.rA << 8 | this.rB);
            }
            case REG_X: {
                return Utils.extendWord(this.rX);
            }
            case REG_Y: {
                return Utils.extendWord(this.rY);
            }
            case REG_U: {
                return Utils.extendWord(this.rU);
            }
            case REG_S: {
                return Utils.extendWord(this.rS);
            }
            case REG_PC: {
                return Utils.extendWord(this.rPC);
            }
        }
        throw new IllegalArgumentException("Not a register : " + (Object)((Object)operand));
    }

    public int getReg16(Operand operand, int n) {
        switch (operand) {
            case REG_A: {
                return n | this.rA;
            }
            case REG_B: {
                return n | this.rB;
            }
            case REG_CC: {
                return n | this.rCC;
            }
            case REG_DP: {
                return n | this.rDP;
            }
            case REG_D: {
                return this.rA << 8 | this.rB;
            }
            case REG_X: {
                return this.rX;
            }
            case REG_Y: {
                return this.rY;
            }
            case REG_U: {
                return this.rU;
            }
            case REG_S: {
                return this.rS;
            }
            case REG_PC: {
                return this.rPC;
            }
        }
        throw new IllegalArgumentException("Not a register : " + (Object)((Object)operand));
    }

    public void setReg(Operand operand, int n) {
        switch (operand) {
            case REG_A: {
                this.setA(n);
                return;
            }
            case REG_B: {
                this.setB(n);
                return;
            }
            case REG_CC: {
                this.setCC(n);
                return;
            }
            case REG_DP: {
                this.setDP(n);
                return;
            }
            case REG_D: {
                this.setD(n);
                return;
            }
            case REG_X: {
                this.setX(n);
                return;
            }
            case REG_Y: {
                this.setY(n);
                return;
            }
            case REG_U: {
                this.setU(n);
                return;
            }
            case REG_S: {
                this.setS(n);
                return;
            }
            case REG_PC: {
                this.setPC(n);
                return;
            }
        }
        throw new IllegalArgumentException("Not a register : " + (Object)((Object)operand));
    }

    public void reset() {
        this.rA = 0;
        this.rB = 0;
        this.rCC = 0;
        this.rDP = 0;
        this.rPC = 0;
        this.rS = 0;
        this.rU = 0;
        this.rX = 0;
        this.rY = 0;
    }

    public static final Operand getOperand(String string) {
        if (string.equals("DP")) {
            return Operand.REG_DP;
        }
        if (string.equals("CC")) {
            return Operand.REG_CC;
        }
        if (string.equals("A")) {
            return Operand.REG_A;
        }
        if (string.equals("B")) {
            return Operand.REG_B;
        }
        if (string.equals("D")) {
            return Operand.REG_D;
        }
        if (string.equals("X")) {
            return Operand.REG_X;
        }
        if (string.equals("Y")) {
            return Operand.REG_Y;
        }
        if (string.equals("U")) {
            return Operand.REG_U;
        }
        if (string.equals("S")) {
            return Operand.REG_S;
        }
        if (string.equals("PC")) {
            return Operand.REG_PC;
        }
        throw new IllegalArgumentException("Not a register : " + string);
    }

    public IPersistentSection getSection() {
        return PersistentSection.CPU_REGS;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write8(this.rCC);
        iPersistenceWriter.write8(this.rA);
        iPersistenceWriter.write8(this.rB);
        iPersistenceWriter.write8(this.rDP);
        iPersistenceWriter.write16(this.rX);
        iPersistenceWriter.write16(this.rY);
        iPersistenceWriter.write16(this.rU);
        iPersistenceWriter.write16(this.rS);
        iPersistenceWriter.write16(this.rPC);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.rCC = iPersistenceReader.readU8();
        this.rA = iPersistenceReader.readU8();
        this.rB = iPersistenceReader.readU8();
        this.rDP = iPersistenceReader.readU8();
        this.rX = iPersistenceReader.readU16();
        this.rY = iPersistenceReader.readU16();
        this.rU = iPersistenceReader.readU16();
        this.rS = iPersistenceReader.readU16();
        this.rPC = iPersistenceReader.readU16();
    }
}

